// EditCard.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditCard.h"
#include <afxtempl.h>

//Added by Bhabananda, Dated:16/02/2022
#include <comdef.h>
//End
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditCard dialog


CEditCard::CEditCard(CWnd* pParent /*=NULL*/)
	: CDialog(CEditCard::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditCard)
	m_ExAccl = _T("");
	m_ExActive = _T("");
	m_ExCardno = _T("");
	m_ExCH = _T("");
	m_ExExpire = _T("");
	m_ExStatus = _T("");
	m_NewCard = _T("");
	m_exPIN1 = _T("");
	m_exPIN2 = _T("");
	m_NewActivationDate = _T("");
	m_NewExpirationDate = _T("");
	m_NewPIN1 = _T("");
	m_NewPIN2 = _T("");
	m_bExNXLimited = FALSE;
	m_bExNXTempCard = FALSE;
	m_iExNXCardType = 0;
	m_nExNXLimit = 0;
	m_nNewNXLimit = 0;
	m_iNewNXCardType = 0;
	m_bNewNXLimited = FALSE;
	m_bNewNXTempCard = FALSE;
	//Vellai - PRO3000 - HBAC API Implementation
	m_nPRO3000CardType2 = -1;
	m_nPRO3000CardType3 = -1;
	m_nPRO3000CardTypeVIP1 = -1;
	m_nPRO3000CardTypeVIP2 = -1;
	m_szMLActivationDate = _T("");	//WUR //WPACT-4867--Mitesh Patel
	m_szMLExpirationDate = _T("");	//WUR //WPACT-4867--Mitesh Patel
	m_MaxAllowedAccesslevel = 0; //WPACT-5689
	m_blALActivationDate = FALSE; //WPACT-5699
	//}}AFX_DATA_INIT
}

CEditCard ::CEditCard(IApplication *pApp):CDialog(CEditCard::IDD, NULL)
{
	m_ExAccl = _T("");
	m_ExActive = _T("");
	m_ExCardno = _T("");
	m_ExCH = _T("");
	m_ExExpire = _T("");
	m_ExStatus = _T("");
	m_NewCard = _T("");
	m_exPIN1 = _T("");
	m_exPIN2 = _T("");
	m_NewActivationDate = _T("");
	m_NewExpirationDate = _T("");
	m_NewPIN1 = _T("");
	m_NewPIN2 = _T("");
	m_bExNXLimited = FALSE;
	m_bExNXTempCard = FALSE;
	m_iExNXCardType = 0;
	m_nExNXLimit = 0;
	m_nNewNXLimit = 0;
	m_iNewNXCardType = 0;
	m_bNewNXLimited = FALSE;
	m_bNewNXTempCard = FALSE;
	//Vellai - PRO3000 - HBAC API Implementation
	m_nPRO3000CardType2 = -1;
	m_nPRO3000CardType3 = -1;
	m_nPRO3000CardTypeVIP1 = -1;
	m_nPRO3000CardTypeVIP2 = -1;

	m_szMLActivationDate = _T("");	//WUR //WPACT-4867--Mitesh Patel
	m_szMLExpirationDate = _T("");	//WUR //WPACT-4867--Mitesh Patel
	m_MaxAllowedAccesslevel = 0; //WPACT-5689
	m_bAccessTypeMulExpiry = FALSE;
	m_blALActivationDate = FALSE;
	pApplication = pApp;
	pApplication->GetAccessLevelType(&iAccessType);
	//pApplication->GetAccessLevelMultipleTypeWithExpiry(&m_bAccessTypeMulExpiry); //WPACT-4867--Mitesh Patel
	//Added by Bhaba, Dated:02/03/2022
	HRESULT hr = pApplication->GetAccessLevelMultipleTypeWithExpiry(&m_bAccessTypeMulExpiry);  
	if (FAILED(hr)) {
		m_bAccessTypeMulExpiry = FALSE;
	}
	//End
	CoInitialize(0);
	//End
	pCard.CreateInstance(__uuidof(Card));

}
//Added by Bhaba, Dated:02/03/2022
CEditCard::~CEditCard()
{
	CoUninitialize();
}
//End

void CEditCard::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditCard)
	DDX_Control(pDX, IDC_NEWCARD, m_Cnt_newCard);
	DDX_Control(pDX, IDC_EX_MULACCL_LIST, m_Ex_MulAcclList);
	DDX_Control(pDX, IDC_MUL_ACCLLIST, m_Mul_AcclList);
	DDX_Control(pDX, IDC_LIST_MLACCESSLEVEL, m_MulAccessLevelList); //WUR
	DDX_Control(pDX, IDC_EXSTATUS, m_Cnt_ExStatus);
	DDX_Control(pDX, IDC_EXCARD, m_cnt_ExCard);
	DDX_Control(pDX, IDC_EXEXPIRE, m_Cnt_ExExpire);
	DDX_Control(pDX, IDC_EXCH, m_Cnt_ExCH);
	DDX_Control(pDX, IDC_EXACTIVE, m_Cnt_ExActive);
	DDX_Control(pDX, IDC_EXACCL, m_cnt_ExAccl);
	DDX_Control(pDX, IDC_NEWSTATUS, m_NewStatus);
	DDX_Control(pDX, IDC_NEWCHLIST, m_NewCHList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_NEWACCLLIST, m_NewAcclList);
	DDX_Control(pDX, IDC_CARDLIST, m_CardList);
	DDX_Text(pDX, IDC_EXACCL, m_ExAccl);
	DDX_Text(pDX, IDC_EXACTIVE, m_ExActive);
	DDX_Text(pDX, IDC_EXCARD, m_ExCardno);
	DDX_Text(pDX, IDC_EXCH, m_ExCH);
	DDX_Text(pDX, IDC_EXEXPIRE, m_ExExpire);
	DDX_Text(pDX, IDC_EXSTATUS, m_ExStatus);
	DDX_Text(pDX, IDC_NEWCARD, m_NewCard);
	DDX_Text(pDX, IDC_EXPIN1, m_exPIN1);
	DDX_Text(pDX, IDC_EXPIN2, m_exPIN2);
	DDX_Text(pDX, IDC_NEWACTIVATION, m_NewActivationDate);
	DDX_Text(pDX, IDC_NEWEXPIRATION, m_NewExpirationDate);
	DDX_Text(pDX, IDC_NEW_PIN1, m_NewPIN1);
	DDX_Text(pDX, IDC_NEW_PIN2, m_NewPIN2);
	DDX_Text(pDX, IDC_ALEXPIRATIONDATE, m_szMLExpirationDate); //WUR
	DDX_Text(pDX, IDC_ALACTIVATIONDATE, m_szMLActivationDate); //WUR
	DDX_Check(pDX, IDC_CHK_NXLIMIT_EX, m_bExNXLimited);
	DDX_Check(pDX, IDC_CHK_NXTEMP_EX, m_bExNXTempCard);

	DDX_Text(pDX, IDC_NX_CARDTYPE_EX, m_iExNXCardType);
	DDX_Text(pDX, IDC_NX_LIMITS_EX, m_nExNXLimit);

	DDX_Text(pDX, IDC_NX_NEW_LIMITS, m_nNewNXLimit);
	DDX_Text(pDX, IDC_NX_NEW_CARDTYPE, m_iNewNXCardType);

	DDX_Check(pDX, IDC_CHK_NEW_NXLIMIT, m_bNewNXLimited);
	DDX_Check(pDX, IDC_CHK_NEW_NXTEMP, m_bNewNXTempCard);
	DDX_Radio(pDX, IDC_OPT_PRO3K_CARD_STD2, m_nPRO3000CardType2);
	DDX_Radio(pDX, IDC_OPT_PRO3K_CARD_STD3, m_nPRO3000CardType3);
	DDX_Radio(pDX, IDC_OPT_PRO3K_CARD_VIP2, m_nPRO3000CardTypeVIP1);
	DDX_Radio(pDX, IDC_OPT_PRO3K_CARD_VIP3, m_nPRO3000CardTypeVIP2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditCard, CDialog)
	//{{AFX_MSG_MAP(CEditCard)
	ON_BN_CLICKED(IDEDIT, OnEdit)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDC_BTN_SET_EXPIRY, OnSetALInfo)
	ON_CBN_SELCHANGE(IDC_CARDLIST, OnSelchangeCardlist)
	ON_CBN_SELCHANGE(IDC_LIST_MLACCESSLEVEL, OnClickLstSelectedAccessLevel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditCard message handlers
BOOL CEditCard::OnInitDialog() 
{
	CDialog::OnInitDialog();

	UpdateData(FALSE);
	
	LoadAccounts();//load the account list in WP-CS database
	m_NewStatus.SetCurSel(0);
	if (0==iAccessType)
	{
		m_cnt_ExAccl.ShowWindow(SW_SHOW);
		m_Ex_MulAcclList.ShowWindow(SW_HIDE);
		m_NewAcclList.ShowWindow(SW_SHOW);
		m_Mul_AcclList.ShowWindow(SW_HIDE);
	}
	if(1== iAccessType)
	{
		m_cnt_ExAccl.ShowWindow(SW_HIDE);
		m_Ex_MulAcclList.ShowWindow(SW_SHOW);
		m_NewAcclList.ShowWindow(SW_HIDE);
		m_Mul_AcclList.ShowWindow(SW_SHOW);
	}

	if (m_bAccessTypeMulExpiry)   //WPACT-4867--Show/Hide as per Flag set in DB Mitesh Patel
	{
		m_MulAccessLevelList.ShowWindow(SW_SHOW);
		GetDlgItem(IDC_LIST_MLACCESSLEVEL)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_MLACCESSLEVELS)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_ACTIVATION_DATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_EXPIRATION_DATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_ACCESSLEVEL_DATE_GROUP1)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_ALACTIVATIONDATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_ALEXPIRATIONDATE)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BTN_SET_EXPIRY)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->ShowWindow(SW_SHOW);
	}
	else
	{
		m_MulAccessLevelList.ShowWindow(SW_HIDE);
		GetDlgItem(IDC_LIST_MLACCESSLEVEL)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_MLACCESSLEVELS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_ACTIVATION_DATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EXPIRATION_DATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_ACCESSLEVEL_DATE_GROUP1)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_ALACTIVATIONDATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_ALEXPIRATIONDATE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BTN_SET_EXPIRY)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->ShowWindow(SW_HIDE);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CEditCard ::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.SetItemData( m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID );
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CEditCard :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();
		
		long lAccountID = m_AcctList.GetItemData(index_Acct);		

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{
				m_SubAcctList.SetItemData( m_SubAcctList.AddString(pSubAccount->AccountName),pSubAccount->AccountID );
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CEditCard ::LoadCardsList()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int index_sub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(index_sub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vCards;
		vCards.Clear();
		// get Card details in WP-CS database server by specified account
		pApplication->GetCardsByAccountName(bstrAcctName, bstrSubAcctName, &vCards); 
				
		if(vCards.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICard *pCard = NULL;
		
		COleSafeArray sa(vCards);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICard,(void**)&pCard);
			if (pCard != NULL)
			{
				//m_CardList.AddString(pCard->CardNumber);		
				//Added by Bhaba, Dated:02/03/2022
				BSTR bstrCardNumber = nullptr;
				pCard->get_CardNumber(&bstrCardNumber);
				m_CardList.AddString(bstrCardNumber);
				//End
				pCard->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_CardList.SetCurSel(0);
}
//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
time_t CEditCard::GetTimeData(CString strDate)
{
	time_t dtActivationDate = 0;  //WPACT-4867 Mitesh
	if(strDate == "")
		return dtActivationDate;
	COleDateTime dtOleActDate;
	dtOleActDate.ParseDateTime(strDate, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);

	if (dtOleActDate != 0 && dtOleActDate.GetMonth() == -1)
	{
		AfxMessageBox(L"DateFormat is not written correctly");
		return dtActivationDate;
	}

	CTime tAct(dtOleActDate.GetYear(), dtOleActDate.GetMonth(), dtOleActDate.GetDay(), dtOleActDate.GetHour(), dtOleActDate.GetMinute(), dtOleActDate.GetSecond());
	dtActivationDate = tAct.GetTime();
	return dtActivationDate;
}
void CEditCard ::GetCardDetails()
{
	if(m_bAccessTypeMulExpiry)
	{
		//mapStrMALAccExpiry.RemoveAll();
		GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(L"");
		GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(L"");
		GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(L"");
		
		//WPACT-5689 Check Max Allowed Date for Access level with Expiration
		CARD_MALINFO ObjALDate;
		POSITION pos = mapStrMALAccExpiry.GetStartPosition();
		CString ALKey;
		m_MaxAllowedAccesslevel = 0;
		while (pos != NULL)
		{
			mapStrMALAccExpiry.GetNextAssoc(pos, ALKey, ObjALDate);
			ObjALDate.ALActivationDate = 0;
			ObjALDate.ALExpirationDate = 0;
			mapStrMALAccExpiry.SetAt(ALKey, ObjALDate);
		}
	}
	m_MaxAllowedAccesslevel=0;
		short nRes = -1;
		//select account name 
		int index = m_AcctList.GetCurSel();
	long lAccountID = m_AcctList.GetItemData(index);
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		//select Card no
		int index_card = m_CardList.GetCurSel();
		CString sCardno;
		m_CardList.GetLBText(index_card ,sCardno);
		BSTR bstrCardno = sCardno.AllocSysString();
		// Getparticular card details
		_variant_t vCard;
		vCard.Clear();
		pApplication->GetCardbyCardNumber(bstrCardno,bstrAcctName, bstrSubAcctName, &vCard);
		
		if(vCard.vt ==  VT_EMPTY)
		{
			return;
		}
		//UpdateData(TRUE);
		if( vCard.vt & VT_DISPATCH)
		{
			
			ICardPtr pcard(vCard.pdispVal);
			 /*
			long lCardID = pcard->CardID;
			m_ExCardno =CString(((LPWSTR)pcard->CardNumber));
			m_ExActive =CString(((LPWSTR)pcard->ActivationDate));
			m_ExExpire =CString(((LPWSTR)pcard->ExpirationDate));
			m_exPIN1   =CString(((LPWSTR)pcard->PIN1));//Bharani Jun-17-08
			*/
			//Added by Bhaba, Dated:02/03/2022
			long lCardID = 0;
			pcard->get_CardID(&lCardID);
			
			BSTR bstrCardNoTemp = nullptr;
			pcard->get_CardNumber(&bstrCardNoTemp);
			m_ExCardno = CString(((LPWSTR)bstrCardNoTemp));
			
			BSTR bstrActDateTemp = nullptr;
			pcard->get_ActivationDate(&bstrActDateTemp);
			m_ExActive = CString(((LPWSTR)bstrActDateTemp));

			BSTR bstrExpDateTemp = nullptr;
			pcard->get_ExpirationDate(&bstrExpDateTemp);
			m_ExExpire = CString(((LPWSTR)bstrExpDateTemp));

			BSTR PIN1Temp = nullptr;
			pcard->get_PIN1(&PIN1Temp);
			m_exPIN1 = CString(((LPWSTR)PIN1Temp));
			//End

			if (0==iAccessType)
			{
				//m_ExAccl   = CString(((LPWSTR)pcard->AccessLevelName));
				//Added by Bhaba, Dated:02/03/2022
				BSTR bstrAccesslvlNameTemp = nullptr;
				pcard->get_AccessLevelName(&bstrAccesslvlNameTemp);
				m_ExAccl = CString(((LPWSTR)bstrAccesslvlNameTemp));
				//End
			}
			if(1==iAccessType)
		{
			long lCount = 0;
			if (m_bAccessTypeMulExpiry)
			{
				_variant_t vAcclslID;
				vAcclslID.Clear();
				_variant_t vAcclsActivationDate; 		//WPACT-4866 - Arti
				_variant_t vAcclsExirationDate; 		//WPACT-4866 - Arti
				vAcclsActivationDate.Clear();
				vAcclsExirationDate.Clear();
				
				//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
				//Update Activation Date and Expiration date for AccessLevel
				pApplication->GetAcessLevelsWithMultipleExpiryDatesByAccountIDCardID(lAccountID, lCardID, &vAcclslID, &vAcclsActivationDate, &vAcclsExirationDate);
				if (vAcclslID.vt != VT_EMPTY)
				{
					COleSafeArray saAcclsID(vAcclslID);
					COleSafeArray saAcclsActivationDate(vAcclsActivationDate);
					COleSafeArray saAcclsExpirationDate(vAcclsExirationDate);

					lCount = vAcclslID.parray->rgsabound->cElements;
					if (lCount > 0)
					{
						for (long iter = 0; iter < lCount; iter++)
						{
							//saAccls.GetElement(&iter,(void*)&bstrAccessLevels[iter]);
							//DB_CARD_ALINFO objAccesLevel;
							
							CARD_MALINFO ObjALInfo;
							BSTR bstAcivationDate;
							BSTR bstExpirationDate;
							saAcclsID.GetElement(&iter, &ObjALInfo.inAccessLevelID);
							saAcclsActivationDate.GetElement(&iter, (void*)&bstAcivationDate);
							saAcclsExpirationDate.GetElement(&iter, (void*)&bstExpirationDate);
							
							BSTR bstAcclName;
							long lnAclId = ObjALInfo.inAccessLevelID;
							pApplication->GetAccessLevelNameByID(lnAclId, &bstAcclName); //WPACT-4867 Mitesh Patel

							CString stAcclName = (CString)bstAcclName;
							CString stALActDate = (CString)bstAcivationDate;
							CString stALExpDate = (CString)bstExpirationDate;
							

							if (mapStrMALAccExpiry.Lookup(stAcclName, ObjALInfo))
							{
								ALEXPIRYDATA objAlExpData;
								objAlExpData.sAccessLevel = stAcclName;
								objAlExpData.sActivationDate = stALActDate;
								objAlExpData.sExpirationDate = stALExpDate;
								mapALExpiryDate.SetAt(stAcclName, objAlExpData);

								ObjALInfo.ALActivationDate = GetTimeData(stALActDate);
								ObjALInfo.ALExpirationDate = GetTimeData(stALExpDate);
								if(ObjALInfo.ALActivationDate != (time_t)0 || ObjALInfo.ALActivationDate != (time_t)0)
								{
									m_MaxAllowedAccesslevel++;
								}
								mapStrMALAccExpiry.SetAt(stAcclName, ObjALInfo);
								
							}
							SysFreeString(bstAcivationDate);
							SysFreeString(bstExpirationDate);
						}
					}
				}
			//WPACT-5689 Temp Access Assigned
			if(m_MaxAllowedAccesslevel > 0)
			{
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Temp Access Assigned"));
			}else 
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Default Access"));
			}
				_variant_t vAccls;
				vAccls.Clear();
				//vAccls = pcard->AccessLevels;
				//Added by Bhaba, Dated:02/03/2022
				VARIANT vAccl;
				pcard->get_AccessLevels(&vAccl);
				vAccls = static_cast<_variant_t>(vAccl);
				//End
				if (vAccls.vt != VT_EMPTY)
				{
					long uBound =0 ;
					COleSafeArray sa(&vAccls);
					sa.GetUBound(1,&uBound);
					BSTR bstrsAccl;
					for(long i =0 ;i <= uBound ; i++)
					{
						sa.GetElement(&i,(void*)&bstrsAccl);
						CString sAccl = CString(bstrsAccl);
						//AfxMessageBox(scard);
						m_Ex_MulAcclList.AddString(sAccl);
					}
				}
			}
			//get cardStatus;
			CString sCardStatus;
			//sCardStatus.Format(L"%ld",pcard->CardStatus);
			
			//Added by Bhaba, Dated:02/03/2022
			long lcardStatus = 0;
			pcard->get_CardStatus(&lcardStatus);
			sCardStatus.Format(L"%ld", lcardStatus);
			//End
			m_ExStatus =sCardStatus;
			//get cardHolderID
			CString sCHid;
			//sCHid.Format(L"%ld",pcard->CardHolderID);
			//Added by Bhaba, Dated:02/03/2022
			long lcardHolderID = 0;
			pcard->get_CardHolderID(&lcardHolderID);
			sCHid.Format(L"%ld", lcardHolderID);
			//End
			m_ExCH = sCHid;
			//NetAXS Fields, for SE/PE API
			CString sTempText;
			//m_iExNXCardType = pcard->NetAXSCardType;
			//m_bExNXLimited = pcard->NetAXSLimitedCard;
			//m_bExNXTempCard = pcard->NetAXSTempCard;
			//m_nExNXLimit = pcard->NetAXSUsageLimit;

			//Added by Bhaba, Dated:02/03/2022
			pcard->get_NetAXSCardType(&m_iExNXCardType);

			long ExNXLimited = 0;
			pcard->get_NetAXSLimitedCard(&ExNXLimited);
			m_bExNXLimited = static_cast<BOOL>(ExNXLimited);

			long ExNXTempCard = 0;
			pcard->get_NetAXSTempCard(&ExNXTempCard);
			m_bExNXTempCard = static_cast<BOOL>(ExNXTempCard);

			pcard->get_NetAXSUsageLimit(&m_nExNXLimit);
			//End 
			
			//Vellai - PRO3000 - HBAC API Implementation
			//nRes = pcard->PRO3000CardType;
			
			//Added by Bhaba, Dated:02/03/2022
			pcard->get_PRO3000CardType(&nRes);
			//End

			m_NewCard = m_ExCardno;
		}

		UpdateData(FALSE);
		
		//Vellai - PRO3000 - HBAC API Implementation
		//set PRO3000 card type - Standard/VIP card
		CButton* pButton1 = (CButton*) GetDlgItem(IDC_OPT_PRO3K_CARD_VIP2);
		CButton* pButton2 = (CButton*) GetDlgItem(IDC_OPT_PRO3K_CARD_VIP3);	
		CButton* pButton3 = (CButton*) GetDlgItem(IDC_OPT_PRO3K_CARD_STD2);
		CButton* pButton4 = (CButton*) GetDlgItem(IDC_OPT_PRO3K_CARD_STD3);
				
		if(nRes == 1)
		{
			pButton1->SetCheck(1);
			pButton2->SetCheck(1);
			pButton3->SetCheck(0);
			pButton4->SetCheck(0);
			//AfxMessageBox("SetCheck = 1");
			//m_nPRO3000CardTypeVIP1 = 1;
			//m_nPRO3000CardTypeVIP2 = 1;
			
		}
		else
		{
			pButton1->SetCheck(0);
			pButton2->SetCheck(0);
			pButton3->SetCheck(1);
			pButton4->SetCheck(1);
			//AfxMessageBox("SetCheck = 0");
			//m_nPRO3000CardType2 = 1;
			//m_nPRO3000CardType3 = 1;
		}


		if(NULL != vCard.pdispVal)
		{
			//vCard.pdispVal->Release();
			vCard.Clear();
		}
	
}
void CEditCard ::LoadCardHolders()
{
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vCHs;
		vCHs.Clear();
		pApplication->GetCardHoldersByAccountName(bstrAcctName,bstrSubAcctName, &vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);

		m_NewCHList.AddString(L"0");

		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
			if (pCH != NULL)
			{
				CString sCHid;
				//sCHid.Format(L"%ld",pCH->CardHolderID);
				//Added by Bhaba, Dated:02/03/2022
				long lcardHolderID = 0;
				pCH->get_CardHolderID(&lcardHolderID);
				sCHid.Format(L"%ld", lcardHolderID);
				//End
				m_NewCHList.AddString(sCHid);
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_NewCHList.SetCurSel(0);
}
//WPACT-4867--Mitesh Patel
DWORD CEditCard::GetAccessLevelIDFromACName(CString stAcclName)
{
	DWORD dwAcclValue = 0;
	BSTR bstrAcctName;
	BSTR bstrSubAcctName;
	BSTR bstrAcclName;
	LONG lCardstatus;
	long lAccountID = 0;
	long lSubAccountID = 0;

	COleSafeArray saAccessLevels;
	_bstr_t bstrAccl;
	VARIANT vAccls;

	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index, sAcctName);
	bstrAcctName = sAcctName.AllocSysString();

	//select sub account name 
	int indexSub = m_SubAcctList.GetCurSel();
	CString sSubAcctName;
	m_SubAcctList.GetLBText(indexSub, sSubAcctName);
	bstrSubAcctName = sSubAcctName.AllocSysString();


	bstrAcclName = stAcclName.AllocSysString();

	_variant_t vAccl;
	vAccl.Clear();
	pApplication->GetAccessLevelByName(bstrAcclName, bstrAcctName, &vAccl);

	if (vAccl.vt == VT_EMPTY)
	{
		return 0;
	}
	if (vAccl.vt & VT_DISPATCH)
	{
		long i = 0;
		saAccessLevels.CreateOneDim(VT_INT, 1);
		IAccessLevelPtr pAccl(vAccl.pdispVal);
		//dwAcclValue = pAccl->AccessLevelID;
		//Added by Bhaba, Dated:02/03/2022
		long lAccesslvlId = 0;
		pAccl->get_AccessLevelID(&lAccesslvlId);
		dwAcclValue = static_cast<DWORD>(lAccesslvlId);
		//End
		//saAccessLevels.PutElement(&i,static_cast<long *>(&lAcclID));
	}

	return dwAcclValue;

}
void CEditCard ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				//Added by Bhaba, Dated:02/03/2022
				BSTR AccessLevelName = nullptr;
				pAccl->get_AccessLevelName(&AccessLevelName);
				//End
				if(0==iAccessType)
				{
					//m_NewAcclList.AddString(pAccl->AccessLevelName);
					//Added by Bhaba, Dated:02/03/2022
					m_NewAcclList.AddString(AccessLevelName);
					//End
				}
				if(1 == iAccessType)
				{
					//m_Mul_AcclList.AddString(pAccl->AccessLevelName);
					//Added by Bhaba, Dated:02/03/2022
					m_Mul_AcclList.AddString(AccessLevelName);
					//End
				if (m_bAccessTypeMulExpiry)
				{
					//CString cstr = (LPCTSTR)pAccl->AccessLevelName;
					//Added by Bhaba, Dated:02/03/2022
					CString cstr = (LPCTSTR)AccessLevelName;
					//End
					DWORD dwALID = GetAccessLevelIDFromACName(cstr);
					CARD_MALINFO obj;
					ALEXPIRYDATA objAlExpD;
					objAlExpD.sActivationDate = "";
					objAlExpD.sExpirationDate = "";

					obj.inAccessLevelID = dwALID;
					obj.ALActivationDate = (time_t)0;;
					obj.ALExpirationDate = (time_t)0;;
					//m_MulAccessLevelList.AddString(pAccl->AccessLevelName); //WUR
					//Added by Bhaba, Dated:02/03/2022
					m_MulAccessLevelList.AddString(AccessLevelName);
					//End
					mapStrMALAccExpiry.SetAt(cstr, obj);
					mapALExpiryDate.SetAt(cstr, objAlExpD);
				}
				}
				pAccl->Release();
			}
			pDisp->Release();
		}
	//UpdateData(FALSE);
	m_NewAcclList.SetCurSel(0);
	//Added by Bhaba, Dated:02/03/2022
	UpdateData(FALSE);
	//End
}
void CEditCard::OnEdit() 
{
		BSTR bstrAcctName = nullptr;
		BSTR bstrAcclName = nullptr;
		LONG lCardstatus = 0;
		LONG lCardHolderID = 0;
		BSTR bstrActivateDate = nullptr;
		BSTR bstrExpireDate = nullptr;
		BSTR bstrCardno = nullptr;
		BSTR bstrExCardNumber = nullptr;
		BSTR bstrNewPIN1=SysAllocString(L"");//Bharani Jun-17-08
		BSTR bstrNewPIN2=SysAllocString(L"");//Bharani Jun-17-08

		//For Error Messages, SE/PE API -- Guru
		CString strMsg = _T("");

	
		UpdateData(TRUE);
			
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			
			bstrAcctName = sAcctName.AllocSysString();
		}

		//select sub account name 
		BSTR bstrSubAcctName = nullptr;
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName = L"";
		if (indexSub <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		bstrSubAcctName = sSubAcctName.AllocSysString();
		}


		//select card number
		int index_card = m_CardList.GetCurSel();
		CString sCardno = L"";
		if (index_card <0)
			bstrExCardNumber = SysAllocString(L"");
		else
		{
			m_CardList.GetLBText(index_card,sCardno);
			bstrExCardNumber = sCardno.AllocSysString();
		}
		//select access level List
		int index_Accl = m_NewAcclList.GetCurSel();
		CString sAcclName = L"";
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_NewAcclList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}
		
	 //select CardStatus
		
		long index_status =m_NewStatus.GetCurSel()+1;
		if ( index_status < 0)
		{
			AfxMessageBox(L"Select Card Status");
			return;
		}
		else
		{
			lCardstatus = index_status;
		}
	
	//card no;

		bstrCardno = m_NewCard.AllocSysString();

	//getcardholderID
		int index_CH =m_NewCHList.GetCurSel();
		if (index_CH <0)
		{
			lCardHolderID = 0;			
		}
		else
		{
			CString sCHid;
			m_NewCHList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);	
		}
		
	 //select activation Date
		bstrActivateDate = m_NewActivationDate.AllocSysString();
	//select expiration Date
		bstrExpireDate = m_NewExpirationDate.AllocSysString();
	//select PIN Numbers --Bharani-- Jun-17-08
		bstrNewPIN1=m_NewPIN1.AllocSysString();
		bstrNewPIN2=m_NewPIN2.AllocSysString();

	//set card properties
		
		//pCard->AccountName		= bstrAcctName;
		//pCard->CardNumber		= bstrCardno;
		//pCard->SubAccountName		= bstrSubAcctName;

		//Added by Bhaba, Dated:02/03/2022
		pCard->put_AccountName(bstrAcctName);
		pCard->put_CardNumber(bstrCardno);
		pCard->put_SubAccountName(bstrSubAcctName);
		//End
		if(0== iAccessType)
		{
			//pCard->AccessLevelName	= bstrAcclName;
			//Added by Bhaba, Dated:02/03/2022
			pCard->put_AccessLevelName(bstrAcclName);
			//End
		}
		if(1== iAccessType)
		{
			// select the Access levels from access level list
			COleSafeArray saAccessLevels;
			_bstr_t bstrAccl;
			VARIANT vAccls;
			CArray<int,int> sels; //selected access level list 

			 int n = m_Mul_AcclList.GetSelCount();
			
			 if(n <= 0)
			 {
				 vAccls.vt = VT_NULL;
			 }
			else
			{
				saAccessLevels.CreateOneDim(VT_BSTR,n);
				sels.SetSize(n);
				 
				 m_Mul_AcclList.GetSelItems(n, sels.GetData());

				 //*****************************************************************************
				 // This segment of code only works if the listbox is non-owner-draw,          *
				 // or is owner-draw with LBS_HASSTRINGS                                       *
				 // So first check to make sure this is true                                   *
				 //*****************************************************************************
				 ASSERT( (GetStyle() & (LBS_OWNERDRAWFIXED | LBS_OWNERDRAWVARIABLE)) == 0 || //*
						 (GetStyle() & LBS_HASSTRINGS) == LBS_HASSTRINGS);                   //*
																							 //*
				 // Extract the text and put it to safe array;                                                        
				 for(long i = 0; i < n; i++)                                                  
				 {                                                      
					CString t;                                                              
					m_Mul_AcclList.GetText(sels[i], t);
					bstrAccl = t.AllocSysString();
					saAccessLevels.PutElement(&i,static_cast<BSTR>(bstrAccl));
				 } 
					vAccls = saAccessLevels.Detach();
			//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
			if (m_bAccessTypeMulExpiry)
			{
				COleSafeArray saAccessLevelsID;
				COleSafeArray saAccessLevelsActivationD;
				COleSafeArray saAccessLevelsExpiresD;
				VARIANT vAcclsID;
				VARIANT vAcclsActivationD;
				VARIANT vAcclsExpiresD;

				saAccessLevelsID.CreateOneDim(VT_INT, n);
				saAccessLevelsActivationD.CreateOneDim(VT_I4, n);
				saAccessLevelsExpiresD.CreateOneDim(VT_I4, n);

				for (long i = 0; i < n; i++)
				{
					CString t;
					m_Mul_AcclList.GetText(sels[i], t);
					CARD_MALINFO ObjALInfo;
					if (mapStrMALAccExpiry.Lookup(t, ObjALInfo))
					{
						//WPACT-5804 : Bhabananda, Dated:03/03/2022
						saAccessLevelsID.PutElement(&i, &ObjALInfo.inAccessLevelID);
						saAccessLevelsActivationD.PutElement(&i, &ObjALInfo.ALActivationDate);
						saAccessLevelsExpiresD.PutElement(&i, &ObjALInfo.ALExpirationDate);
						//End
					}
				}

				vAcclsID = saAccessLevelsID.Detach();
				vAcclsActivationD = saAccessLevelsActivationD.Detach();
				vAcclsExpiresD = saAccessLevelsExpiresD.Detach();
				pCard->PutAccessLevelsExpiryDates(vAcclsID, vAcclsActivationD, vAcclsExpiresD);
			}

		}
			//pCard->AccessLevels = vAccls;
			 
			//Added by Bhaba, Dated:02/03/2022
			 pCard->put_AccessLevels(vAccls);
			//End
		}
		//pCard->CardStatus		= lCardstatus;
		//pCard->CardHolderID		= lCardHolderID;
		//pCard->ActivationDate	= bstrActivateDate;
		//pCard->ExpirationDate	= bstrExpireDate;

		//Added by Bhaba, Dated:02/03/2022
		pCard->put_CardStatus(lCardstatus);
		pCard->put_CardHolderID(lCardHolderID);
		pCard->put_ActivationDate(bstrActivateDate);
		pCard->put_ExpirationDate(bstrExpireDate);
		//End
		//set PIN --Bharani-- Jun-17-08
		//pCard->PIN1				= bstrNewPIN1;
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_PIN1(bstrNewPIN1);
		//End
		//#if defined WPPCS
		//pCard->PIN2				= bstrNewPIN2;
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_PIN2(bstrNewPIN2);
		//End
		//#endif
		// Place the NetAXS Fields in the ICard Object, for SE/PE -- Guru
		//pCard->NetAXSCardType = m_iNewNXCardType;
		//pCard->NetAXSTempCard = m_bNewNXTempCard;
		//pCard->NetAXSLimitedCard = m_bNewNXLimited;
		//pCard->NetAXSUsageLimit = m_nNewNXLimit;
		
		//Added by Bhaba, Dated:02/03/2022
		pCard->put_NetAXSCardType(m_iNewNXCardType);
		pCard->put_NetAXSTempCard(m_bNewNXTempCard);
		pCard->put_NetAXSLimitedCard(m_bNewNXLimited);
		pCard->put_NetAXSUsageLimit(m_nNewNXLimit);
		//End

		//Vellai - PRO3000 - HBAC API Implementation
		if(m_nPRO3000CardType3 == 1)
		{
			//pCard->PRO3000CardType = 1;	
			//Added by Bhaba, Dated:02/03/2022
			pCard->put_PRO3000CardType(1);
			//End
		}

//now add a card 
		//Added by Bhaba, Dated:17/02/2022, For Test Only
		long lstatus = -1;
		try
		{
			HRESULT hrError = pApplication->EditCard(bstrExCardNumber, bstrAcctName, bstrSubAcctName, pCard, &lstatus);
			OutputDebugString(L"");
		}
		catch (const _com_error& ce)
		{
			CString csErr = ce.ErrorMessage();
			_bstr_t csErrDes = ce.Description();
			OutputDebugString(L"");
		}
		//End
		strMsg.Format(_T("%ld : "), lstatus);
		//get the output error values		
		if (lstatus == 101)
		{
			strMsg += _T("Card Number Exists");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 102)
		{
			strMsg += _T("Invalid Card Number");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 103)
		{
			strMsg += _T("Invalid Card Status");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 104)
		{
			strMsg += _T("Invalid Access");
			AfxMessageBox(strMsg);
			return;
		}
			if( lstatus == 105)
		{
			strMsg += _T("Invalid Account");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 108)
		{
			strMsg += _T("Invalid Card Length");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 109)
		{
			strMsg += _T("Invalid PIN Format");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 106)
		{
			strMsg += _T("Invalid Year < 1971 or > 2037");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 107)
		{
			strMsg += _T("Invalid Activation Date");
			AfxMessageBox(strMsg);
			return;
		}
		if( lstatus == 110)
		{
			strMsg += _T("Invalid Access Level Type");
			AfxMessageBox(strMsg);
			return;
		}
		//The New Messages for SE/PE API -- Guru
		if (lstatus == 111)
		{
			strMsg += _T("Invalid Usage Limits");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 112)
		{
			strMsg += _T("Invalid Expiry Date");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 113)
		{
			strMsg += _T("Invalid Card Type");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 114)
		{
			strMsg += _T("Invalid Temp Card");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 115)
		{
			strMsg += _T("Invalid Limted Card");
			AfxMessageBox(strMsg);
			return;
		}
		if (lstatus == 116)
		{
			strMsg += _T("Card Cannot be Edited");
			AfxMessageBox(strMsg);
			return;
		}

		if (lstatus == 1)
		{
			strMsg += _T("Card Edit Failed");
			AfxMessageBox(strMsg);
			return;
		}
		if ( lstatus == 0)
		{
			strMsg += _T("Card Edit Succeeded");
			AfxMessageBox(strMsg);
			CDialog::OnOK();
		}
		
	UpdateData(FALSE);
}

void CEditCard::OnSelchangeAcctlist() 
{
	m_CardList.ResetContent();
//	LoadCardsList();
	m_NewAcclList.ResetContent();
	m_Mul_AcclList.ResetContent();
	m_MulAccessLevelList.ResetContent();
	m_SubAcctList.ResetContent();
	//LoadAccessLevels();
	m_NewCHList.ResetContent();
	//LoadCardHolders();
	LoadSubAccounts();

	m_cnt_ExCard.SetWindowText(L"");
	m_Cnt_ExStatus.SetWindowText(L"");
	m_Cnt_ExExpire.SetWindowText(L"");
	m_Cnt_ExActive.SetWindowText(L"");
	m_Cnt_ExCH.SetWindowText(L"");
	m_cnt_ExAccl.SetWindowText(L"");
	m_Ex_MulAcclList.ResetContent();
	m_Cnt_newCard.SetWindowText(L"");
		
}

void CEditCard::OnSelchangeSubAcctlist() 
{
	m_CardList.ResetContent();
	LoadCardsList();
	m_NewAcclList.ResetContent();
	m_Mul_AcclList.ResetContent();
	m_MulAccessLevelList.ResetContent();
	m_Ex_MulAcclList.ResetContent();
	
	m_NewCHList.ResetContent();
	LoadCardHolders();
	LoadAccessLevels();
	m_cnt_ExCard.SetWindowText(L"");
	m_Cnt_ExStatus.SetWindowText(L"");
	m_Cnt_ExExpire.SetWindowText(L"");
	m_Cnt_ExActive.SetWindowText(L"");
	m_Cnt_ExCH.SetWindowText(L"");
	m_cnt_ExAccl.SetWindowText(L"");
	m_Ex_MulAcclList.ResetContent();
	m_Cnt_newCard.SetWindowText(L"");
	
}

void CEditCard::OnSelchangeCardlist() 
{
	// TODO: Add your control notification handler code here
	m_Ex_MulAcclList.ResetContent();
	GetCardDetails();
	m_Cnt_newCard.SetFocus();
	m_Cnt_newCard.SetSel(0,-1);
	
}
CString CEditCard::FormatDate(CTime time)
{
	// get time in system time format
	SYSTEMTIME st;
	time.GetAsSystemTime(st);

	// get necessary buffer size
	int nSize = GetDateFormat(
		LOCALE_SYSTEM_DEFAULT, 
		LOCALE_NOUSEROVERRIDE, 
		&st, 
		NULL, 
		NULL, 
		0);

	// format the date
	CString strDate;
	GetDateFormat(
		LOCALE_SYSTEM_DEFAULT, 
		LOCALE_NOUSEROVERRIDE, 
		&st, 
		NULL, 
		strDate.GetBuffer(nSize), 
		nSize);

	strDate.ReleaseBuffer();

	return strDate;
}

void CEditCard::OnClickLstSelectedAccessLevel()
{
	int p = m_MulAccessLevelList.GetCurSel();
	m_MulAccessLevelList.SetCurSel(p);
	CString strAccessLevel;
	CString strActivationDate;
	CString strExpirationDate;
	dtDbActivationDate = 0;
	m_MulAccessLevelList.GetText(p, strAccessLevel);

	m_blALActivationDate = FALSE;
	GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(L"");
	GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(L"");

	CARD_MALINFO ObjALInfo;

	if (mapStrMALAccExpiry.Lookup(strAccessLevel, ObjALInfo))
	{
		ALEXPIRYDATA objAlExpData;
		if (mapALExpiryDate.Lookup(strAccessLevel, objAlExpData))
		{
			GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(objAlExpData.sActivationDate);
			GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(objAlExpData.sExpirationDate);
			COleDateTime dtActDate;

			if(!m_szMLActivationDate.IsEmpty())
			{
				dtActDate.ParseDateTime(m_szMLActivationDate, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);
				CTime tAct(dtActDate.GetYear(), dtActDate.GetMonth(), dtActDate.GetDay(), dtActDate.GetHour(), dtActDate.GetMinute(), dtActDate.GetSecond());
				dtDbActivationDate = tAct.GetTime();
			}
			
			if(objAlExpData.sActivationDate != "") // Older Activation date is already validated at time of it was set. No need to verifly now.
			{
				m_blALActivationDate = TRUE;
			}else
				m_blALActivationDate = FALSE;
		}
	}
	strAccessLevel.ReleaseBuffer();
}

bool CEditCard::DateValidation(COleDateTime ActDate, COleDateTime ExpDate)
{

	if ((ActDate.GetYear() == ExpDate.GetYear()) && (ActDate.GetMonth() == ExpDate.GetMonth()) && (ActDate.GetDay() == ExpDate.GetDay()))
	{
		return false;
	}

	CTime tAct(ActDate.GetYear(), ActDate.GetMonth(), ActDate.GetDay(), ActDate.GetHour(), ActDate.GetMinute(), ActDate.GetSecond());
	time_t dtActivationDate = tAct.GetTime();

	CTime tExp(ExpDate.GetYear(), ExpDate.GetMonth(), ExpDate.GetDay(), ExpDate.GetHour(), ExpDate.GetMinute(), ExpDate.GetSecond());
	time_t dtExpirationDate = tExp.GetTime();

	if ((dtActivationDate > dtExpirationDate))
	{
		return false;
	}

	return true;
}


void CEditCard::OnSetALInfo()
{
	BSTR bstrMLActivateDate;
	BSTR bstrMLExpiryDate;
	CString stAccessLevelName;
	
	time_t dtActivationDate = 0;   //WPACT-4867 Mitesh
	time_t dtExpirationDate = 0;

	int p = m_MulAccessLevelList.GetCurSel();
	m_MulAccessLevelList.SetCurSel(p);
	m_MulAccessLevelList.GetText(p, stAccessLevelName);

	
	GetDlgItem(IDC_ALACTIVATIONDATE)->GetWindowText(m_szMLActivationDate);
	GetDlgItem(IDC_ALEXPIRATIONDATE)->GetWindowText(m_szMLExpirationDate);

	CARD_MALINFO ObjALInfo;

	COleDateTime dtActDate, dtExpDate;

	if(m_szMLActivationDate != "")
	{
		dtActDate.ParseDateTime(m_szMLActivationDate, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);
		CTime tAct(dtActDate.GetYear(), dtActDate.GetMonth(), dtActDate.GetDay(), dtActDate.GetHour(), dtActDate.GetMinute(), dtActDate.GetSecond());
		dtActivationDate = tAct.GetTime();

		if (dtActDate.GetMonth() == -1 )
		{
			AfxMessageBox(L"AccessLevel Activation Date is not written correctly");
			return;
		}
	}
	
	if(m_szMLExpirationDate != "")
	{
		dtExpDate.ParseDateTime(m_szMLExpirationDate, VAR_DATEVALUEONLY, LANG_USER_DEFAULT);
		CTime tExp(dtExpDate.GetYear(), dtExpDate.GetMonth(), dtExpDate.GetDay(), dtExpDate.GetHour(), dtExpDate.GetMinute(), dtExpDate.GetSecond());
		dtExpirationDate = tExp.GetTime();
		if (dtExpDate.GetMonth() == -1 )
		{
			AfxMessageBox(L"AccessLevel Expiration Date is not written correctly");
			return;
		}
	}

	//WPACT-5689 Check Max Allowed Date for Access level with Expiration
	if(m_MaxAllowedAccesslevel >= 8 && (dtActDate != 0 || dtExpDate !=0))
	{
		AfxMessageBox(L"Access level with Expiration has reached to Max Allowed 8");
		GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(L"");
		GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(L"");
		return;
	}

	if(dtActDate == 0 && dtExpDate ==0)
	{
		dtExpirationDate = 0;  //WPACT-5663 Set to clear AL Activation and Expiration Date.
		dtActivationDate = 0;
	}
	if(dtActDate == 0 && dtExpDate !=0)
	{
		AfxMessageBox(L"Activation Date is required");
		return;
	}

	DWORD dwALID = GetAccessLevelIDFromACName(stAccessLevelName);
	
	//WPACT-4867 API modification for Multiple AL with expiry check //Mitesh Patel
	ALEXPIRYDATA objAlExpData;
	objAlExpData.sAccessLevel = stAccessLevelName;
	objAlExpData.sActivationDate = m_szMLActivationDate;
	objAlExpData.sExpirationDate = m_szMLExpirationDate;
	
	CTime tTmpCurrDate = CTime::GetCurrentTime().GetTime();
	CTime tTodaysDate(tTmpCurrDate.GetYear(), tTmpCurrDate.GetMonth(), tTmpCurrDate.GetDay(), 0, 0, 0, -1);
	time_t dtTodaysDate = tTodaysDate.GetTime();
	
	if(dtDbActivationDate != dtActivationDate) //In case of Older Activation Date changes .. Validation required.
		m_blALActivationDate = FALSE;
	if ( dtActivationDate != 0 && dtActivationDate < dtTodaysDate && m_blALActivationDate == FALSE )   
	{
		AfxMessageBox(L"Activation Date must be grater than or equal to current Date");
		return;	
	}

	if (dtExpirationDate != 0 && dtExpirationDate < dtTodaysDate)
	{
		AfxMessageBox(L"Expiration Date must be grater than or equal to current Date");
		return;	
	}

	if (dtExpirationDate > 0 && !DateValidation(dtActDate, dtExpDate))
	{
		AfxMessageBox(L"Expiration Date must be greater than Activation Date");
	}
	else
	{
		ObjALInfo.inAccessLevelID = dwALID;
		ObjALInfo.ALActivationDate = dtActivationDate;
		ObjALInfo.ALExpirationDate = dtExpirationDate;

		if (dwALID != 0)
		{
			if(m_MaxAllowedAccesslevel >= 8 && (dtActDate != 0 || dtExpDate !=0))
			{
				AfxMessageBox(L"Access level with Expiration has reached to Max Allowed 8");
				GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(L"");
				GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(L"");
				return;		
			}//WPACT-5689
			mapALExpiryDate.SetAt(stAccessLevelName, objAlExpData);
			mapStrMALAccExpiry.SetAt(stAccessLevelName, ObjALInfo);

			//WPACT-5689 Check Max Allowed Date for Access level with Expiration
			CARD_MALINFO ObjALDate;
			POSITION pos = mapStrMALAccExpiry.GetStartPosition();
			CString ALKey;
			m_MaxAllowedAccesslevel = 0;
			while (pos != NULL)
			{
				mapStrMALAccExpiry.GetNextAssoc(pos, ALKey, ObjALDate);
				if(ObjALDate.ALActivationDate != (time_t)0 || ObjALDate.ALActivationDate != (time_t)0)
				{
					m_MaxAllowedAccesslevel++;
				}
			}

			//WPACT-5689 Temp Access Assigned
			if(m_MaxAllowedAccesslevel > 0)
			{
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Temp Access Assigned"));
			}else
				GetDlgItem(IDC_STATIC_DEFAULT_ACCESS)->SetWindowText(_T("Default Access"));
			//WPACT-5689 Check Max Allowed Date for Access level with Expiration
			if(m_MaxAllowedAccesslevel >= 8 && (dtActDate != 0 || dtExpDate !=0))
			{
				AfxMessageBox(L"Access level with Expiration has reached to Max Allowed 8");
				GetDlgItem(IDC_ALEXPIRATIONDATE)->SetWindowText(L"");
				GetDlgItem(IDC_ALACTIVATIONDATE)->SetWindowText(L"");
				return;		
			}//WPACT-5689
		}
	}
}